(* ======================================================================= *)
(* Project: HASP Dumps to .REG and .INC ("DB") files converter             *)
(* Title  : DUMP2ALL.EXE (Dump2All Converter Project)                      *)
(* Comment: Converting dumps for collecting them in comfortable format     *)
(* Version: 2.1                                                            *)
(* Created: 27-Mar-1999          Update: 19-Jan-2003                       *)
(* ----------------------------------------------------------------------- *)
(* (c) 1999, 2003, Sp0Raw, Remote Access Network, Inc. <sp0raw@mail.ru>    *)
(*                                                                         *)
(* This is Remote Access Network, Inc. internal source, not for publishing *)
(* ----------------------------------------------------------------------- *)
(* History:                                                                *)
(*    < Described at README.TXT chapter "What's new" >                     *)
(*                                                                         *)
(* Compile:                                                                *)
(*    (Borland Pascal v7.0)  bpc.exe DUMP2ALL.PAS                          *)
(*    (Virtual Pascal v2.xx) vpc.exe DUMP2ALL.PAS                          *)
(*                                                                         *)
(* WARNING:                                                                *)
(*    We assumes no responsibility on any side-effect in using this code   *)
(* ======================================================================= *)

Program
 Dump2All;

{.$DEFINE METEO} { Especially for MeteO }
{.$DEFINE EXPIRED} { Expiration on dumps (works only with "METEO" defined) }
{$DEFINE SECRET} { Include Secret Table or not, if defined it will be included }
{.$DEFINE CHUNK} { Include chunked memory or not, if defined it will be included }

{$IFDEF EXPIRED}
   {$IFNDEF METEO}
   {$DEFINE METEO}
   {$ENDIF}
{$ENDIF}

{$Q-,R+,I-}

Uses
 Dos, Misc;

Const
 { Dump types }
 _UNKNOWN     = 0; { Type of dump file is not recognized           }
 _RAM_SCANNER = 1; { Dump was made by RAM Scanner's dumper         }
 _STPARK      = 2; { Dump was made by stpark's or "MeteO"'s dumper }

 { Convertation types }
 _ALL = 0; { Convert to .REG and .INC file }
 _REG = 1; { Convert to .REG file }
 _DB  = 2; { Convert to .INC file }

 { File names }
 _DEFAULT_NAME = 'HASPDUMP.REG'; { Default name of registry with collection of dumps }
 _INI_FILE     = 'DUMP2ALL.INI'; { Name of the .INI file }

 { Errors }
 _ERR_NO_ERRORS    = 0; { No errors          }
 _ERR_CANT_OPEN    = 1; { Cannot open file   }
 _ERR_CANT_CREATE  = 2; { Cannot create file }
 _ERR_CANT_READ    = 3; { Cannot read file   }
 _ERR_INVALID_DUMP = 3; { Invalid dump       }

 { Memory type (standard constants!) }
 _MEM_128 = 128; { 112 bytes of memory                          }
 _MEM_256 = 256; { 240 bytes of memory (not exist in real life) }
 _MEM_512 = 512; { 496 bytes of memory                          }

 { Memory types }
 _NO_MEMORY = 0; { Without memory }
 _M1        = 1; { 112 bytes      }
 _M4        = 4; { 496 bytes      }

 { Dongle types }
 _HASP       = 0; { HASP without memory          }
 _MEMOHASP   = 1; { MemoHASP M1 or M4            }
 _TIMEHASP   = 3; { TimeHASP without Memo memory }
 _NETHASP    = 4; { NetHASP                      }
 _TIMEHASPM4 = 5; { TimeHASP M4                  }

Type
 tHaspInternal = Packed Record { HASP memory behind API }
    ID        : Longint; { HighID : Word; LowID : Word }
    Reserved1 : Array [1 .. 6] Of Byte; { Always FFh }
    Users     : Word; { Amount of NetHASP users, FFFFh - Unlimited }
    Reserved2 : Word; { Always FFh }
    KeyType   : Word; { FFFFh - MemoHASP, FFFEh - NetHASP }
    End;
 tHaspDumpR = Packed Record { RAM Scanner's dump structure }
    Password1 : Word;
    Password2 : Word;
    { ᪨ Pascal  ন Union ⠪  ਢ:    Case  }
    {  . ,   .  ᠬ ᪮  ⮩ 樨, }
    {  뢠 Case-   . 諮   䨪 }
    { _128   _512,   ࠩ  ᨢ ᬮ  㤮     }
    { ࠡ  ன.                                                  }
    Case Size : Word Of { Size of physical HASP memory in bytes }
       _MEM_128 :
          (Internal_128 : tHaspInternal;
           Memory_128   : Array [1 .. 112] Of Byte);
       _MEM_512 :
          (Internal_512 : tHaspInternal;
           Memory_512   : Array [1 .. 496] Of Byte);
    End;
 tHaspDumpS = Packed Record { stpark's dump structure }
    Password1   : Word;
    Password2   : Word;
    SecretTable : Array [1 .. 8] Of Byte;
    ID          : Longint; { HighID : Word; LowID : Word }
    Chunk       : Array [1 .. 12] Of Byte; { Always FFh }
    Memory      : Array [1 .. 112] Of Byte;
    End;

Var
 { .INI file variables }
 Ask : String[3];
 KeyString, Copyright : String;
 { Other stuff }
 fI  : File;               { Just a binary file      }
 fIR : File Of tHaspDumpR; { RAM Scanner's dump file }
 fIS : File Of tHaspDumpS; { stpark's dump file      }
 fO  : Text;
 DumpType : Byte;
 HaspDumpR : tHaspDumpR; { Maximum structure size is 518 bytes }
 HaspDumpS : tHaspDumpS Absolute HaspDumpR;
 TimeMemory : Array [1 .. 16] Of Byte;
 MemType : Byte; { Size of memory: 0 - without memory; 1 - M1; 4 - M4 }
 KeyType : Byte; { Type of dongle }
 KeyGen  : Byte; { Generation of dongle: 3 - HASP3; 4 - HASP4 }
 Description : String;
 {$IFDEF METEO}
 InternalDescription : String;
 {$ENDIF}
 B1, B2, B3 : Byte;

Const
 Version : String[3] = '2.1';

Function GetPasswords : String;
Begin
{     ⨯   뢠 ஫,    }
{ 砫   ᠭ    ᫮, ⮬ ⠥  ࢮ }
{ .                                                              }
GetPasswords := DW2HS(HaspDumpS.Password1) + DW2HS(HaspDumpS.Password2);
End;

Procedure PrintHelp;
Begin
Writeln('Usage:');
Writeln('DUMP2ALL.EXE InFile [OutFile]        < [1]');
Writeln('DUMP2ALL.EXE /DB InFile [OutFile]    < [2]');
Writeln('DUMP2ALL.EXE /REG [OutFile]          < [3]');
Writeln('DUMP2ALL.EXE /REG-HEAP               < [4]');
Writeln('DUMP2ALL.EXE /DB-HEAP                < [5]');
Writeln('DUMP2ALL.EXE /ALL                    < [6]'#13#10);
Writeln('[1] > InFile to [OutFile] .REG (Default OutFile: InFile.REG)');
Writeln('[2] > InFile to [OutFile] .INC (Default OutFile: InFile.INC)');
Writeln('[3] > *.HSP/*.DMP/*.HED to one [OutFile] .REG (Default OutFile: ' + _DEFAULT_NAME + ')');
Writeln('[4] > *.HSP/*.DMP/*.HED to a lot of .REG-files');
Writeln('[5] > *.HSP/*.DMP/*.HED to a lot of .INC-files');
Writeln('[6] > *.HSP/*.DMP/*.HED to a lot of .REG- and .INC-files'#13#10);
Writeln('Example:');
{ 1 }
Writeln('DUMP2ALL.EXE 61F51158.HSP                 -> 61F51158.HSP to 61F51158.REG');
Writeln('DUMP2ALL.EXE 19237B83.DMP DECODES.REG     -> 19237B83.DMP to DECODES.REG');
Writeln('DUMP2ALL.EXE 1C.HED                       -> 1C.HED to 1C.REG');
Writeln('DUMP2ALL.EXE 1C77.HED 1C77348.REG         -> 1C77.HED to 1C77348.REG');
{ 2 }
Writeln('DUMP2ALL.EXE /DB 7E730691.DMP             -> 7E730691.DMP to 7E730691.INC');
Writeln('DUMP2ALL.EXE /DB 584B4AE9.HSP MASTCAM.INC -> 584B4AE9.HSP to MASTCAM.INC');
Writeln('DUMP2ALL.EXE /DB UNTITLE1.HED             -> UNTITLE1.HED to UNTITLE1.INC');
Writeln('DUMP2ALL.EXE /DB SOME.HED DUMP.INC        -> SOME.HED to DUMP.INC');
{ 3 }
Writeln('DUMP2ALL.EXE /REG                         -> *.HSP/*.DMP/*.HED to ' + _DEFAULT_NAME);
Writeln('DUMP2ALL.EXE /REG SP0RAW.REG              -> *.HSP/*.DMP/*.HED to SP0RAW.REG');
{ 4 }
Writeln('DUMP2ALL.EXE /REG-HEAP                    -> *.HSP/*.DMP/*.HED to *.REG');
{ 5 }
Writeln('DUMP2ALL.EXE /DB-HEAP                     -> *.HSP/*.DMP/*.HED to *.INC');
{ 6 }
Writeln('DUMP2ALL.EXE /ALL                         -> *.HSP/*.DMP/*.HED to *.REG/*.INC');
Halt($00);
End;

Procedure ReadIni;
Var
 fI : Text;

Begin
Assign(fI, _INI_FILE);
Reset(fI);
If IOResult <> 0 Then
   Begin
   Writeln('Can not open ' + _INI_FILE + '!');
   Halt($02);
   End;
Writeln('Reading parameters from ' + _INI_FILE + '...');
Readln(fI, Ask);
Readln(fI, KeyString);
Readln(fI, Copyright);
Close(fI);
Ask := UpcaseS(Ask);
If (Ask <> 'YES') and
   (Ask <> 'NO') Then Ask := 'NO'; { 祭  㬮砭: No }
If KeyString[Length(KeyString)] <> '\' Then KeyString := KeyString + '\';
Writeln('[x] Ask description for every dump: ', Ask);
Writeln('[x] Path to dump:');
Writeln('    "', KeyString, '"');
Writeln('[x] Copyright: "', Copyright, '"'#13#10);
End;

Function OpenFiles(Const InName : String) : Byte;
Var
 Size : Longint;

Begin
OpenFiles := _ERR_NO_ERRORS;
DumpType := _UNKNOWN;
Assign(fI, InName);
Reset(fI, 1);
If IOResult <> 0 Then
   Begin
   OpenFiles := _ERR_CANT_OPEN;
   Exit;
   End;
Size := FileSize(fI);
Close(fI);
Case Size Of
   134, 518 :
      Begin
      DumpType := _RAM_SCANNER; { 112 bytes or 496 bytes dumps }
      KeyGen := 3; { Current version of HASPGRAB supports only HASP3 dongles }
      If Size = 134 Then MemType := _M1
      Else MemType := _M4;
      { ⠫  ;) -   _128  _512... }
      Case HaspDumpR.Internal_128.KeyType Of
         $FFFF : KeyType := _MEMOHASP;
         $FFFE : KeyType := _NETHASP;
         Else KeyType := _MEMOHASP;
         End;
      Assign(fIR, InName);
      Reset(fIR); { 뢠 䠩 ⨯஢ }
      End;
   140 :
      Begin
      DumpType := _STPARK; { 112 bytes dumps only }
      KeyGen := 3; { HASPDUMP supports only MemoHASP3 M1 dongles }
      KeyType := _MEMOHASP;
      MemType := _M1;
      Assign(fIS, InName);
      Reset(fIS); { 뢠 䠩 ⨯஢ }
      End
   Else OpenFiles := _ERR_INVALID_DUMP;
   End;
End;

Function WriteFile(CvtFlag : Byte; Const OutName : String) : Byte;
Var
 tOutName : String;

Begin
WriteFile := _ERR_NO_ERRORS;
Assign(fO, OutName);
If OutName[1] = '/' Then
   Begin
   tOutName := OutName;
   Delete(tOutName, 1, 1);
   Assign(fO, tOutName);
   Append(fO); { 뢠 㦥 騩 騩 䠩 }
   End;
If (OutName[1] <> '/') or (IOResult <> 0) Then
   Begin
   Rewrite(fO); { ⠥ ᮧ 䠩  :                      }
                { 1.  ⤥ 䠩  - ;            }
                { 2. 騩 䠩   ,  ⪠  㦥 }
                {    騩  ਢ  ᯥ.                  }
   If IOResult <> 0 Then
      Begin
      WriteFile := _ERR_CANT_CREATE;
      Exit;
      End;
   If CvtFlag = _REG Then Writeln(fO, 'REGEDIT4');
   End;
End;

Function ReadDump : Byte;
Var
 Err : Integer;

Begin
ReadDump := _ERR_NO_ERRORS;
Case DumpType Of
   _RAM_SCANNER :
      Begin
      Read(fIR, HaspDumpR);
      Err := IOResult;
      { 訡,  ⠥ 뢠  䠩 ଠ樨 , 祬 ⠬ }
      { ॠ쭮  ᮤন.   ந室  砥, ᫨  134 ⮢ }
      { 䠩 ⠥  518  .                              }
      If (not ((Err = $64) and (HaspDumpR.Size = _MEM_128))) and
         (Err <> 0) Then  
         Begin
         ReadDump := _ERR_CANT_READ;
         Exit;
         End;
      Close(fIR);
      End;
   _STPARK :
      Begin
      Read(fIS, HaspDumpS);
      If IOResult <> 0 Then
         Begin
         ReadDump := _ERR_CANT_READ;
         Exit;
         End;
      Close(fIS);
      End;
   End;
End;

{ Parsing Aladdin's HaspEdit dump-file to convert it to internal variables }
Procedure ParseHED(Const InName : String);
Var
 fI : Text;
 S  : String;
 W1, W2 : Word;

Begin
DumpType := _RAM_SCANNER;
Assign(fI, InName);
Reset(fI);
If IOResult <> 0 Then
   Begin
   Writeln('Cannot open input file "', InName, '"!');
   Halt($FF);
   End;
HaspDumpR.Internal_128.ID := 0; { HASP ID is always 0, just because it's not stored in dump :( }
While not EOF(fI) Do
   Begin
   Readln(fI, S);
   If (Length(S) = 0) or (S[1] = ';') Then Continue;
   If Pos('Pass1=', S) = 1 Then
      Begin
      Delete(S, 1, 6);
      HaspDumpR.Password1 := S2L(S);
      Continue;
      End;
   If Pos('Pass2=', S) = 1 Then
      Begin
      Delete(S, 1, 6);
      HaspDumpR.Password2 := S2L(S);
      Continue;
      End;
   If Pos('KeyType=', S) = 1 Then
      Begin
      HaspDumpR.Size := _MEM_128;
      Delete(S, 1, 8);
      If Pos('HASP4', S) = 1 Then
         Begin
         KeyGen := 4; { It's a HASP4 }
         Delete(S, 1, 5);
         If (Length(S) > 0) and (S[1] = ' ') Then Delete(S, 1, 1)
         Else
            Begin { HASP4 without memory }
            HaspDumpR.Size := _NO_MEMORY;
            KeyType := _HASP;
            MemType := _NO_MEMORY;
            Continue;
            End;
         If S = 'M1' Then { MemoHASP4 M1 }
            Begin
            HaspDumpR.Size := _MEM_128;
            KeyType := _MEMOHASP;
            MemType := _M1;
            Continue;
            End;
         If S = 'M4' Then { MemoHASP4 M4 }
            Begin
            HaspDumpR.Size := _MEM_512;
            KeyType := _MEMOHASP;
            MemType := _M4;
            Continue;
            End;
         If S = 'Time' Then { TimeHASP4 M4 }
            Begin
            HaspDumpR.Size := _MEM_512;
            KeyType := _TIMEHASPM4;
            MemType := _M4;
            Continue;
            End;
         If Pos('Net-', S) = 1 Then { NetHASP4 }
            Begin
            HaspDumpR.Size := _MEM_512;
            KeyType := _NETHASP;
            MemType := _M4;
            Continue;
            End;
         Continue;
         End;
      If Pos('MemoHASP-', S) = 1 Then
         Begin
         KeyGen := 3; { It's a HASP 3 }
         Delete(S, 1, 9);
         If S = '1' Then { MemoHASP3 M1 }
            Begin
            HaspDumpR.Size := _MEM_128;
            KeyType := _MEMOHASP;
            MemType := _M1;
            Continue;
            End;
         If S = '4' Then { MemoHASP3 M4 }
            Begin
            HaspDumpR.Size := _MEM_512;
            KeyType := _MEMOHASP;
            MemType := _M4;
            Continue;
            End;
         Continue;
         End;
      If S = 'TimeHASP' Then { TimeHASP3   }
         Begin
         KeyGen := 3; { It's a HASP3 }
         HaspDumpR.Size := _NO_MEMORY;
         KeyType := _TIMEHASP;
         MemType := _NO_MEMORY;
         Continue;
         End;
      If S = 'TimeHASP-4' Then { TimeHASP3 M4 }
         Begin
         KeyGen := 3; { It's a HASP3 }
         HaspDumpR.Size := _MEM_512;
         KeyType := _TIMEHASPM4;
         MemType := _M4;
         Continue;
         End;
      {  ஢७,    ⠪ : }
      If Pos('NetHASP-', S) = 1 Then { NetHASP3 }
         Begin
         KeyGen := 3; { It's a HASP3 }
         HaspDumpR.Size := _MEM_512;
         KeyType := _NETHASP;
         MemType := _M4;
         Continue;
         End;
      Continue;
      End;
   If S = '[MemoHASPMemory]' Then
      Begin
      Readln(fI, S);
      S := Tab2Spaces(S);
      If Pos('Image=', S) = 1 Then Delete(S, 1, 6)
      Else Continue;
      B2 := 0;
      If MemType = _M1 Then B2 := 7;
      If MemType = _M4 Then B2 := 31;
      W2 := 1; { Indexing variable must be word, because of amount of memory }
      For B1 := 1 To B2 Do
         Begin
         S := TrimL(Tab2Spaces(S));
         If S[Length(S)] = '\' Then S[Length(S)] := ' ';
         S := TrimR(S); S := S + ' '; { 樠  ஡,  Delete 7 ᨬ ࠢ쭮 ࠡ⠫ }
         While Length(S) > 0 Do
            Begin
            W1 := S2L('$' + Copy(S, 3, 4));
            {  ⠭⭠ -   㤠   _128  _512, }
            { 室    .                                }
            HaspDumpR.Memory_512[W2 + 0] := W1 and $FF;
            HaspDumpR.Memory_512[W2 + 1] := W1 shr 8;
            Inc(W2, 2);
            Delete(S, 1, 7);
            End;
         Readln(fI, S);
         If IOResult <> 0 Then Break;
         End;
      Continue;
      End;
   If S = '[TimeHASPMemory]' Then
      Begin
      Readln(fI, S);
      S := Tab2Spaces(S);
      If Pos('Image=', S) = 1 Then Delete(S, 1, 6)
      Else Continue;
      B3 := 1;
      For B1 := 1 To 2 Do
         Begin
         S := TrimL(Tab2Spaces(S));
         If S[Length(S)] = '\' Then S[Length(S)] := ' ';
         S := TrimR(S); S := S + ' '; { 樠  ஡,  Delete 7 ᨬ ࠢ쭮 ࠡ⠫ }
         While Length(S) > 0 Do
            Begin
            TimeMemory[B3] := S2L('$' + Copy(S, 3, 2));
            Inc(B3);
            Delete(S, 1, 5);
            End;
         Readln(fI, S);
         If IOResult <> 0 Then Break;
         End;
      Continue;
      End;
   End;
Close(fI);
End;

Procedure GetInfo;
Begin
Description := '';
{$IFDEF METEO}
InternalDescription := '';
{$ENDIF}
If Ask = 'YES' Then
   Begin
   Writeln('(Need information)');
   Writeln('Input your description for this HASP dump [<Enter> to skip]: ');
   Readln(Description);
   {$IFDEF METEO}
   Writeln('Input your internal description for this HASP dump [<Enter> to skip]: ');
   Readln(InternalDescription);
   {$ENDIF}
   End;
If Description = '' Then Description := GetPasswords;
{$IFDEF METEO}
If InternalDescription = '' Then InternalDescription := GetPasswords;
{$ENDIF}
End;

Function OpenHED(Const Name : String) : Byte;
Begin
OpenHED := _ERR_NO_ERRORS;
Write(AddR(Name, ' ', 8 + 1 + 3), ' [Parsing] ');
ParseHED(Name);
If OpenFiles(Name) = _ERR_CANT_OPEN Then
   Begin
   Writeln('Skipping, cannot open file!');
   OpenHED := _ERR_CANT_OPEN;
   Exit;
   End;
DumpType := _RAM_SCANNER; { Just internal trick }
GetInfo;
End;

Procedure ConvertReg(Const InName, OutName : String);
Var
 DirInfo : SearchRec;
 DT : DateTime;

Begin
Write('[->REG] ');
Writeln(fO, #13#10'[' + KeyString + GetPasswords + ']');
Writeln(fO, '"Name"="' + Description + '"');
{$IFDEF METEO}
Writeln(fO, '"Internal Name"="' + '[' + InternalDescription + ']"');
{$ENDIF}
{$IFDEF SECRET}
If DumpType = _STPARK Then
   Begin
   Write(fO, '"SecretTable"=hex:');
   For B1 := 1 To 7 Do Write(fO, DB2HS(HaspDumpS.SecretTable[B1]), ',');
   Writeln(fO, DB2HS(HaspDumpS.SecretTable[8]));
   End;
{$ENDIF}
Write(fO, '"SN"=dword:');
Case DumpType Of
   _RAM_SCANNER :
      {   Internal_128  Internal_512, ⠪  ID ᯮ }
      {  ᮫⭮ ⮬   .                                    }
      Writeln(fO, DL2HS(HaspDumpR.Internal_128.ID));
   _STPARK :
      Writeln(fO, DL2HS(HaspDumpS.ID));
   End;
{$IFDEF METEO}
Writeln(fO, '"Pwd"=dword:' + GetPasswords);
{$ENDIF}
Writeln(fO, '"Generation"=dword:0000000' + L2S(KeyGen));
Writeln(fO, '"Type"=dword:0000000' + L2S(KeyType));
Writeln(fO, '"Memory"=dword:0000000' + L2S(MemType));
FindFirst(InName, ReadOnly + Hidden + SysFile + Archive, DirInfo);
UnpackTime(DirInfo.Time, DT);
Writeln(fO, '"Created"="' + AddL(L2S(DT.Day), '0', 2) + '.' +
            AddL(L2S(DT.Month), '0', 2) + '.' + AddL(L2S(DT.Year), '0', 4) + ' ' +
            AddL(L2S(DT.Hour), '0', 2) + ':' + AddL(L2S(DT.Min), '0', 2) + ':' +
            AddL(L2S(DT.Sec), '0', 2) + '"');
Writeln(fO, '"Copyright"="' + Copyright + '"');
{$IFDEF METEO}
{$IFDEF EXPIRED}
Writeln(fO, '"Expired"=dword:01DAE282'); { Secret function is private information! ;) }
{$ENDIF}
Writeln(fO, '"CRC"=dword:00000000');
{$ENDIF}
B3 := 6; { Amount of hex-dump strings; 112 bytes memory: 6 + 1 strings }
If DumpType = _RAM_SCANNER Then
   If HaspDumpR.Size = _MEM_512 Then B3 := 30; { 496 bytes memory: 30 + 1 strings }
Write(fO, '"Data"=hex:');
For B2 := 0 To B3 Do
   Begin
   If B2 > 0 Then Write(fO, '           ');
   For B1 := 1 To 16 Do
      Begin
      Case DumpType Of
         { ,  ਭ樯,     "⥩" : }
         { Memory_128  Memory_512, ⮬  ᯮ   }
         {    ⪥ 䨧᪮ .    }
         {    ࠧ   (横  ᠬ ⠭, }
         {    "᪠"     ). ⮬   }
         { ⠥ Memory_512.                                     }
         _RAM_SCANNER : Write(fO, DB2HS(HaspDumpR.Memory_512[B2 * 16 + B1]));
         _STPARK : Write(fO, DB2HS(HaspDumpS.Memory[B2 * 16 + B1]));
         End;
      If B1 < 16 Then Write(fO, ',')
      Else If B2 < B3 Then Writeln(fO, ',\')
      Else Writeln(fO);
      End;
   End;
End;

Procedure ConvertDB(Const InName, OutName : String);
Begin
Write('[->DB] ');
Writeln(fO, ';');
Write(fO, '; ' + Description + ' ');
B1 := 0;
While Length(Description) + 4 + B1 < 78 Do
   Begin
   Write(fO, '');
   Inc(B1);
   End;
Writeln(fO);
Writeln(fO, ';');
{   祬   ⮫쪮    ⢥祭  }
{ ਨ  㭪樨 GetPasswords (. ).                       }
Writeln(fO, 'Password1               dw       ' + DW2HS(HaspDumpS.Password1) + 'h');
Writeln(fO, 'Password2               dw       ' + DW2HS(HaspDumpS.Password2) + 'h');
{$IFDEF SECRET}
If DumpType = _STPARK Then
   Begin
   Write(fO, 'SecretTable             db       ');
   For B1 := 1 To 7 Do Write(fO, DB2HS(HaspDumpS.SecretTable[B1]) + 'h, ');
   Writeln(fO, DB2HS(HaspDumpS.SecretTable[8]) + 'h');
   End;
{$ENDIF}
Write(fO, 'HaspID                  dw       ');
Case DumpType OF
   _RAM_SCANNER :
      {   Internal_128  Internal_512, ⠪  ID ᯮ }
      {  ᮫⭮ ⮬   .                                    }
      Writeln(fO, DW2HS(HaspDumpR.Internal_128.ID and $FFFF) + 'h, ' + DW2HS(HaspDumpR.Internal_128.ID shr 16) + 'h');
   _STPARK :
      Writeln(fO, DW2HS(HaspDumpS.ID and $FFFF) + 'h, ' + DW2HS(HaspDumpS.ID shr 16) + 'h');
   End;
{$IFDEF CHUNK}
Writeln(fO, 'HaspChunk               db       0Ch dup (0FFh)');
{$ENDIF}
Write(fO, 'HaspMemory              db       ');
B3 := 14 - 1; { Amount of hex-dump strings; 112 bytes memory: 14 strings }
If DumpType = _RAM_SCANNER Then
   If HaspDumpR.Size = _MEM_512 Then B3 := 62 - 1; { 496 bytes memory: 62 strings }
For B1 := 0 To B3 Do
   Begin
   If B1 > 0 Then Write(fO, '                        db       ');
   For B2 := 1 To 8 Do
      Begin
      Case DumpType Of
         { 祬  ⠥  Memory_512 .  ਨ }
         {  㭪樨 ConvertReg.                                 }
         _RAM_SCANNER : Write(fO, DB2HS(HaspDumpR.Memory_512[B1 * 8 + B2]));
         _STPARK : Write(fO, DB2HS(HaspDumpS.Memory[B1 * 8 + B2]));
         End;
      If B2 < 8 Then Write(fO, 'h, ')
      Else Writeln(fO, 'h');
      End;
   End;
End;

Procedure Convert(CvtFlag : Byte; Const InName, OutName : String);
Var
 Ext : String;

Begin
Ext := ''; {  筮 砥 ""  }
Write(AddR(InName, ' ', 8 + 1 + 3 + 1));
Case OpenFiles(InName) Of
   _ERR_NO_ERRORS:
      Begin
      If ReadDump = _ERR_CANT_READ Then
         Begin
         Writeln('Cannot read file to structure, I think it is not a HASP dump!');
         Exit;
         End;
      GetInfo;
      If CvtFlag = _ALL Then Ext := '.REG';
      If WriteFile(CvtFlag, OutName + Ext) = _ERR_CANT_CREATE Then
         Begin
         Writeln('Error, cannot create output file: "', OutName + Ext, '"!');
         Exit;
         End
      Else If CvtFlag = _ALL Then Writeln(fO, 'REGEDIT4');
      If (CvtFlag = _REG) or (CvtFlag = _ALL) Then ConvertReg(InName, OutName + Ext);
      { --    ⭮  ,  㥬 ࠧ   䠩 -- }
      If CvtFlag = _ALL Then
         Begin
         Close(fO);
         Ext := '.INC';
         If WriteFile(CvtFlag, OutName + Ext) = _ERR_CANT_CREATE Then
            Begin
            Writeln('Error, cannot create output file: "', OutName + Ext, '"!');
            Exit;
            End;
          End;
      { --  ᯥ樠쭮 ᥪ樨  騬 ( ᮦ)  -- }
      If (CvtFlag = _DB) or (CvtFlag = _ALL) Then ConvertDB(InName, OutName + Ext);
      Close(fO);
      Writeln('Done');
      If Ask = 'YES' Then Writeln;
      End;
   _ERR_CANT_OPEN:
      Writeln('Skipping, cannot open file!');
   _ERR_INVALID_DUMP:
      Writeln('File size is not a 134 or 140 bytes!');
   End;
End;

Var
 { Command-line arguments }
 Switch, InFile, OutFile : String;
 { File name constituent }
 Dir, Name, Ext : String;
 { Searching files }
 DirInfo : SearchRec;
 DT : DateTime;

Procedure ConvertAll;
Begin
FSplit(DirInfo.Name, Dir, Name, Ext); { 塞  䠩  ⮢騥 }
If Switch = '/REG' Then Convert(_REG, DirInfo.Name, '/' + OutFile)
   {  "/" ᯥ樠쭮  ᯮ:   Append }
Else If Switch = '/REG-HEAP' Then Convert(_REG, DirInfo.Name, Name + '.REG')
Else If Switch = '/DB-HEAP' Then Convert(_DB, DirInfo.Name, Name + '.INC')
Else If Switch = '/ALL' Then Convert(_ALL, DirInfo.Name, Name);
     {  ⮬ 砥 ७   ᠬ 㭪樨 }
End;

Begin
Writeln('HASP Dumps to .REG and .INC ("DB") files converter v' + Version);
Writeln('(c) 1999, 2003, Sp0Raw, 2:5030/2731.409 [ sp0raw@mail.ru ]'#13#10);
If ParamCount = 0 Then PrintHelp;
Switch := ParamStr(1);
InFile := ParamStr(2);
OutFile := ParamStr(3);
If (Switch[1] <> '/') Then
   Begin
   OutFile := InFile;
   InFile := Switch;
   Switch := '';
   End;
Switch := UpcaseS(Switch); {   ᤥ   孥 ॣ }
If (Switch <> '') and {   饭,   InFile [OutFile]! }
   (Switch <> '/DB') and
   (Switch <> '/REG') and
   (Switch <> '/REG-HEAP') and
   (Switch <> '/DB-HEAP') and
   (Switch <> '/ALL') Then PrintHelp; {    }
If Switch = '/REG' Then
   If Length(InFile) > 0 Then {  騩 䠩, 㤠  뢠  }
      Begin
      OutFile := InFile;
      InFile := '';
      End;
ReadIni; { ⠥ .INI 䠩 }
Writeln('Converting...');
If Length(OutFile) = 0 Then
   Begin
   FSplit(InFile, Dir, Name, Ext); { 塞  䠩  ⮢騥 }
   If Length(Switch) = 0 Then OutFile := Name + '.REG';
   If Switch = '/DB' Then OutFile := Name + '.INC';
   If UpcaseS(Ext) = '.HED' Then { Input file is dump of HaspEdit by Aladdin }
      Begin
      If OpenHED(InFile) <> _ERR_NO_ERRORS Then Exit;
      If Length(Switch) = 0 Then
         Begin
         WriteFile(_REG, OutFile);
         ConvertReg(InFile, OutFile);
         End;
      If Switch = '/DB' Then
         Begin
         WriteFile(_DB, OutFile);
         ConvertDB(InFile, OutFile);
         End;
      Close(fO);
      Writeln('Done');
      Exit;
      End;
   End;
If Length(Switch) = 0 Then
   Begin
   Convert(_REG, InFile, OutFile);
   Exit;
   End;
If Switch = '/DB' Then
   Begin
   Convert(_DB, InFile, Name + OutFile);
   Exit;
   End;
If Length(OutFile) = 0 Then OutFile := _DEFAULT_NAME;
FindFirst('*.HSP', ReadOnly + Hidden + SysFile + Archive, DirInfo);
While DosError = 0 Do
   Begin
   ConvertAll;
   FindNext(DirInfo);
   End;
FindFirst('*.DMP', ReadOnly + Hidden + SysFile + Archive, DirInfo);
While DosError = 0 Do
   Begin
   ConvertAll;
   FindNext(DirInfo);
   End;
FindFirst('*.HED', ReadOnly + Hidden + SysFile + Archive, DirInfo);
While DosError = 0 Do
   Begin
   FSplit(DirInfo.Name, Dir, Name, Ext); { 塞  䠩  ⮢騥 }
   If OpenHED(DirInfo.Name) <> _ERR_NO_ERRORS Then Continue;
   If Switch = '/REG' Then
      Begin
      {  "/" ᯥ樠쭮  ᯮ:   Append }
      WriteFile(_REG, '/' + OutFile);
      ConvertReg(DirInfo.Name, '/' + OutFile);
      End
   Else If Switch = '/REG-HEAP' Then 
      Begin
      Name := Name + '.REG';
      WriteFile(_REG, Name);
      ConvertReg(DirInfo.Name, Name);
      End
   Else If Switch = '/DB-HEAP' Then
      Begin
      Name := Name + '.INC';
      WriteFile(_DB, Name);
      ConvertDB(DirInfo.Name, Name)
      End
   Else If Switch = '/ALL' Then
      Begin
      WriteFile(_REG, Name + '.REG');
      ConvertReg(DirInfo.Name, Name + '.REG');
      Close(fO);
      WriteFile(_DB, Name + '.INC');
      ConvertDB(DirInfo.Name, Name + '.INC');
      End;
   Close(fO);
   Writeln('Done');
   FindNext(DirInfo);
   End;
End.
